package LCM::ComponentStepWrapper;

use LCM::Component;

use strict;

# This class is used in LCM::Gui::Dialogs::FinalizeDialog to represent component step (e.g. Uninstall scenario)
sub new {
	my ($class, $component) = @_;
	my $self = {};
	bless $self, $class;

	$self->{component} = $component;

	return $self;	
}

sub getStatus {
	my ($self) = @_;
	return $self->{component}->getStatus();
}

sub getName {
	my ($self) = @_;
	return $self->{component}->getComponentName();
}

sub getLogLocation {
	my ($self) = @_;
	return $self->{component}->getLogLocation();
}

sub getWarnings {
	my ($self) = @_;
	return $self->{component}->getWarnings();
}

sub isInternal {
	my ($self) = @_;
	return $self->{component}->isInternal();
}

sub setComponent {
	my ($self, $component) = @_;
	$self->{component} = $component;
}

1;
