package LCM::Configuration::CheckInstallationConfiguration;

use strict;
use SDB::Install::System qw(isSidadmin);
use LCM::Utils::CommonUtils qw ( getSidadmName );
use LCM::Configuration::ValueChangeListeners::CheckInstallation::RemoteExecutionListener;
use base qw (SDB::Install::Configuration::HdbCheck LCM::Configuration::GenericStackAny);

our $section = 'Server';

sub new {
    my $self = shift->SUPER::new ( @_ );

    my $order   = 0;
    my $section = 'HdbCheck';
    my $flavourProductName = $self->getFlavourProductName();
    my $descScope = "Checking $flavourProductName System (all hosts) "
                  . 'or checking local instance only';

    $self->{params} = {
        'RemoteExecution'   => $self->getParamRemoteExecution   ($order++, $section),
        'ScopeCheckTool'    => $self->getParamScope             ($order++, $section, $descScope),
        'Target'            => $self->getParamTarget            ($order++, $section),
        'SID'               => $self->getParamSID               ($order++, $section),
        'PropertyFile'      => $self->getParamPropertyFile      ($order++, $section),
        'Password'          => $self->getParamPassword          ($order++, $section),
        'InstallSSHKey'     => $self->getParamInstallSSHKey     ($order++, $section),
        'RootUser'          => $self->getParamRootUser          ($order++, $section),
        'RootPassword'      => $self->getParamRootPassword      ($order++, $section),
    };
    my $targetParam = $self->{params}->{'Target'};
    $targetParam->{set_interactive}   = 0;
    $targetParam->{hidden}            = 1;
    my $sidParam = $self->{params}->{'SID'};
    $sidParam->{set_interactive}   = 0;
    $sidParam->{hidden}            = 1;

    if(isSidadmin()) {
        $self->setValue('RemoteExecution', 'saphostagent');
        $self->setHidden('RemoteExecution', 1);
    }

    $self->setDefault('ScopeCheckTool', 'system', 1);
    $self->setSkip('ScopeCheckTool', 0);
    $self->_addPassThroughParameters($order);
    $self->_addListeners();

    return $self;
}

# Basically mimics the InternalNetworkConfiguration::checkPassword method
# Consider future refactoring
sub checkPassword {
    my ($self, $password) = @_;
    return 0 if (!$self->initRemoteHosts());

    if(!defined $password){
        $self->appendErrorMessage ("Password is not defined.");
        return 0;
    }elsif(length($password) == 0){
        $self->appendErrorMessage ("Password value cannot be empty.");
        return 0;
    } else {
        require LCM::Configuration::NewDBUser::User;
        my $sidadmUser = new LCM::Configuration::NewDBUser::User(getSidadmName($self));
        $sidadmUser->setMsgLstContext($self->getMsgLstContext());
        my $rc = $sidadmUser->verifyPassword($password, $self);
        if (!defined $rc){
            $self->getMsgLst()->appendMsgLst ($sidadmUser->getErrMsgLst());
            $self->getMsgLst()->addMessage ("Ignoring error => password validation skipped.");
            return 1;
        }
        # Fix for bug 72608. Prevent doubled 'Unknown user password combination' message. The other message comes from 'LCM::Configuration::NewDBUser::User;verifyPasswordSHA'.
        if($rc != 1 && !isSidadmin($self->getSID())) {
            $self->appendErrorMessage ('Unknown user password combination');
        }
        return $rc;
    }
}

# Override
sub getLocalHanaHost {
    my $self = shift();
    my $hdbInstance = $self->getOwnInstance();
    my $hostName = defined($hdbInstance) ? $hdbInstance->get_host() : undef;

    return defined($hostName) ? $hostName : $self->SUPER::getLocalHanaHost(@_);
}

sub _addListeners {
	my ($self) = @_;
    $self->addParameterListener('RemoteExecution', LCM::Configuration::ValueChangeListeners::CheckInstallation::RemoteExecutionListener->new());
	$self->addParameterListener('ScopeCheckTool', sub {
		my ($value, $configuration) = @_;
		if($value eq 'system' && $configuration->isDistributedSystem()){
			$self->enableMultipleHostParameters(1); # 1 - $useSidadmForHostctrl
		}
		return 1;
	});
}

sub _addPassThroughParameters {
    my ($self, $order) = @_;

    my $underlyingToolName = 'hdbcheck';

    my $skipPassThroughParams = ['InstallSSHKey', 'PropertyFile', 'RemoteExecution', 'RootUser', 'Target', 'ScopeCheckTool', 'SID'];

    require SDB::Install::Configuration::HdbCheck;
    my $underlyingTool  = new SDB::Install::Configuration::HdbCheck();
    $self->addPassThroughComponentParams($self->{params}, $order, $underlyingTool, $skipPassThroughParams, $section, $underlyingToolName);
}

sub getAction {
    return 'check_installation';
}

sub getProductName {
    my ($self) = @_;
    my $flavourProductName = $self->getFlavourProductName();
    return "Check $flavourProductName Installation";
}

sub getSummaryTitle {
    my ($self) = @_;
    return "Check Parameters";
}

sub createSummaryTree {
    my ($self) = @_;
    return LCM::SummaryTreeBuilder::buildSummaryTree($self);
}
1;
