package LCM::Configuration::GenericStackConfigurationFactory;

use strict;

use SDB::Install::System qw(isSidadmin isAdmin);

my $instance;

sub getInstance {
    if ( !defined $instance ) {
        $instance = LCM::Configuration::GenericStackConfigurationFactory->_new();
    }
    return $instance;
}

sub _new {
    my ($class) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}

sub createInstallConfiguration{
    my ( $self,$application) = @_;
    require LCM::Configuration::GenericStackInstallConfiguration;
    return new LCM::Configuration::GenericStackInstallConfiguration( $application->{options}, $application->{configfile} );
}

sub createUpdateConfiguration{
    my ( $self,$application) = @_;
    my $actionConfig = $application->getActionConfiguration();
    require LCM::Configuration::GenericStackUpdateConfiguration;
    my $config = new LCM::Configuration::GenericStackUpdateConfiguration( $application->{options}, $application->{configfile} );
    my $sid = $actionConfig->getValue('Action_SID');
    if ( defined $sid ) {
        $config->{params}->{'SID'}->{batchValue} = $sid;
        $config->{params}->{'SelectedSystem'}->{skip} = 1;
    }
    my $skipHostagentCalls = $actionConfig->getValueOrBatchValue('SkipHostagentCalls'); 
    if (defined $skipHostagentCalls) {
        $config->setValue('SkipHostagentCalls', $skipHostagentCalls);
    }
    my $remoteExecution = $actionConfig->getValueOrBatchValue('RemoteExecution');
    if ( defined $remoteExecution ) {
        $config->setValue('RemoteExecution', $remoteExecution);
    }

	$self->_setRemoteExecution($config);

	return $config;
}

sub createUpdateResidentConfiguration {
	my ($self,$application) = @_;

	require LCM::Configuration::GenericStackUpdateResidentConfiguration;
	my $config = new LCM::Configuration::GenericStackUpdateResidentConfiguration( $application->{options}, $application->{configfile} );

	$self->_setRemoteExecution($config);

	return $config;
}

sub createExtractComponentsConfiguration {
    my ($self, $application) = @_;
    require LCM::Configuration::ExtractComponentsConfiguration;
    my $config = new LCM::Configuration::ExtractComponentsConfiguration($application->{options}, $application->{configfile});
    return $config;
}

sub _setRemoteExecution {
	my ($self, $config) = @_;

	#The tool is started with user different from root
	if ((not isAdmin()) or (isSidadmin($config->getSID()))) {
		$config->setValue('RemoteExecution', 'saphostagent');
	}
}

return 1;
