package LCM::Configuration::HdbLcmInstalledActionConfiguration;

use strict;

use base qw (LCM::Configuration::ActionConfiguration Exporter);
use SDB::Install::SysVars qw($isWin);
use SDB::Install::SAPSystem qw(CollectSAPSystems);
use LCM::DevelopmentTrace;

our @EXPORT = qw( IsHostPartOfSystem getNumberOfSystemHosts );

sub new {
	my $self  = shift->SUPER::new(@_);
	my $order = scalar keys %{$self->{params}};

	$self->{params}->{'Uninstall'} = {
		'order'                 => $order++,
		'opt'                   => 'uninstall',
		'type'                  => 'boolean',
		'value'                 => undef,
		'default'               => 0,
		'set_interactive'       => 0,
		'init_with_default'     => 0,
		'str'                   => 'Uninstall system or components',
		'desc'                  => 'Uninstall system or components',
		'mandatory'             => 0,
		'excludeFromConfigDump' => 1,
		'action_switch'=> 1,		
		'help_switch_usage' => '[--pass_through_help]'
	};

	$self->_setValidActions();
	
    $self->{params}->{'Action'}->{'f_init_interactive_values'} = sub {
    	$self->_setValidActionsWithExit();
    };

	return $self;
}

sub _setValidActions {
	my ( $self, ) = @_;
    
    my $systemHosts = getNumberOfSystemHosts();
	my $isGui = $self->{options}->{isGUI};
	
	require LCM::ActionsDetector;
    my $actionsDetector = new LCM::ActionsDetector($self, $systemHosts, $isWin, $isGui);
    $self->{actionsDetector} = $actionsDetector;

    my ($validActions, $validUiActions) = $actionsDetector->getApplicableActions();
    $self->setValidActions( $validActions );
    $self->setActionUIValues( $validUiActions );
    
}

sub _setValidActionsWithExit {
	my ($self, ) = @_;
	
	return if ($self->{exit_initialized}); 
	
	my $validActions = $self->getValidActions();
	push (@$validActions, 'exit');
	$self->setValidActions($validActions);

	$validActions = $self->getActionUIValues();
	push (@$validActions, 'Exit (do nothing)');
	$self->setActionUIValues($validActions);
	
	$self->{exit_initialized} = 1;
}

sub checkAction {
	my ( $self, $action ) = @_;

	if ( $action eq "exit" ) {
		LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
		exit;
	}

	my $validActions = $self->getValidActions();

	return (grep {$_ eq $action} @$validActions);
}

sub checkUninstall {
	my ($self, $value) = @_;
	
	$self->setValue('Action', "uninstall");
	return 1;
}

sub setActionBatchValue {
    my ($self, ) = @_;
    #no default action for the resident hdblcm
}

sub IsHostPartOfSystem {	
	require LCM::Installer;
	my $installer = new LCM::Installer();
	my $sid = $installer->getSid();
	my $allSystems = CollectSAPSystems( undef, 1 );
	my $isHostPartOfSystem = grep { $_ eq $sid } (keys %$allSystems);
	return $isHostPartOfSystem;
}

sub getNumberOfSystemHosts {
    require LCM::Installer;
    my $installer  = new LCM::Installer();
    my $sid        = $installer->getSid();
    my $allSystems = CollectSAPSystems( undef, 1 );
    my $sapSys     = (defined $sid) ? $allSystems->{$sid} : undef;
    my $instance   = (defined $sapSys && $sapSys->hasNewDB())
                     ? $sapSys->getNewDBInstances()->[0] : undef;
    my $allHosts   = (defined $instance) ? $instance->get_allhosts() : undef;

    return (defined $allHosts) ? scalar @$allHosts : 0;
}

sub isScopeInstance {
	my ($self, $fileName) = @_;
    my $persistenceFile = $self->getPersistenceFile($fileName);
    return defined($persistenceFile) && $self->pers_exists( $persistenceFile );
}

sub getPersistenceFile {
    my ($self, $fileName) = @_;

    require SDB::Install::Installer;
    my $installer = new SDB::Install::Installer();

    my $sapSys = $installer->getInstallation($self->getMsgLst());
    if ( defined $sapSys && $sapSys->isa( 'SDB::Install::SAPSystem' ) ) {
        if ( $sapSys->hasNewDB() ) {
            my $hdbInstance = $sapSys->getNewDBInstances()->[0];
            my $hostnameDir = $hdbInstance->get_hostNameDir();
            return File::Spec->catfile($hostnameDir, "$fileName");
        }
    }
    return undef;
}

sub hasPendingSlaveOperations {
	my ($self) = @_;
	my $result = $self->getPendingSlaveOperations();
	return keys(%{$result}) > 0;
}

sub getPendingSlaveOperations {
	my ($self) = @_;

	require SDB::Install::Installer;
	my $installer = new SDB::Install::Installer();

	my $sapSys = $installer->getInstallation($self->getMsgLst());
    
    return {} unless(defined $sapSys && $sapSys->isa('SDB::Install::SAPSystem'));
    return {} unless($sapSys->hasNewDB());

	my $result = {};
	my $hdbInstance = $sapSys->getNewDBInstances()->[0];
	my $hosts = $hdbInstance->get_allhosts();
	my $fileNames = ['hdblcm_configure_internal_network', 'hdblcm_rename_system', 'hdblcm_update_host'];
	my $instanceDir = $hdbInstance->get_instanceDir();
	
	for my $host( @{$hosts} ) {
		for my$fileName ( @{$fileNames} ) {
			if(-f File::Spec->catfile($instanceDir, "$host" ,"$fileName")){
				my $actionName = $fileName;
				$actionName =~ s/^hdblcm_//;
				$result->{$actionName} = [] if(!defined($result->{$actionName}));
				push(@{$result->{$actionName}}, $host); 
			}
		}
	}
    
    return $result;
}

1;
