package LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::AddRemoveHost;
use strict;
use base qw ( LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario );
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::SkippedComponentsManager;
use LCM::Component;
use SDB::Install::Globals qw ($gKeynameHLM);

sub detectSkippedComponents{
    my($self) = @_;
    my $componentsManager = $self->{oComponentsManager};
    my $installedComponents = $componentsManager->{aInstalledComponents};
    if(defined $installedComponents){
        foreach my $installedComponent(@$installedComponents){
            if($componentsManager->shallSkipComponent($installedComponent)){
                $componentsManager->skipComponent($installedComponent);
            }  
        }
     }
}

sub getRemoteRegistrableComponents{ 
	my($self) = @_;
	my $remoteRegistrableComponents = $self->SUPER::getRemoteRegistrableComponents();
	push(@$remoteRegistrableComponents, $gKeynameHLM);
	return $remoteRegistrableComponents 
}

sub getLocalRegistrableComponents{
	my($self) = @_;
	return $self->getRemoteRegistrableComponents() }
return 1;