package LCM::Configuration::Hosts::UpdateHosts::GenericStackUpdateHostConfiguration;

use base qw ( LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration);
use LCM::Configuration::GenericStackAny qw ( $ini_section_general  );
use LCM::Configuration::ValueChangeListeners::FillingCertificatesListener;
use SAPDB::Install::Hostname qw (hostname);
use strict;

sub new {
    my $self = shift->SUPER::new (@_);
    $self->addParameterListener( 'SID', LCM::Configuration::ValueChangeListeners::FillingCertificatesListener->new() );
    return $self;    
}

sub getUpdateHostParameters{
    my($self,$order) = @_;
    my $params;
    $params->{'SID'} = $self->getParamSID( $order++,$ini_section_general, 1 );
    $params->{'Target'} = $self->getParamTarget( $order++,$ini_section_general );
    my $superParams = $self->SUPER::getUpdateHostParameters($order);
    my $mergedParams;
    %{$mergedParams} = (%{$params},%{$superParams});
    $mergedParams->{'HostagentPassword'}  = $self->getParamHostagentPassword ($order++, $ini_section_general);
    return $mergedParams;   
}

sub getLocalHanaHost{
	my $self = shift();
	my $hostname = $self->{localHostname};
	$hostname    = lc(hostname()) if (!defined $hostname);
	return $hostname;
}

return 1;