package LCM::Configuration::Hosts::UpdateHosts::UpdateRemoteHostConfiguration;

use base qw ( LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration);
use LCM::Configuration::GenericStackAny qw ( $ini_section_general  );
use strict;

sub new {
    my $self = shift->SUPER::new (@_);
    return $self;
}

sub getUpdateHostParameters{
	my($self,$order) = @_;
	my $params;
	$params->{'SID'} = $self->getParamSID( $order++,$ini_section_general, 1 );
    $params->{'Target'} = $self->getParamTarget( $order++,$ini_section_general );
    my $superParams = $self->SUPER::getUpdateHostParameters($order);
    my $mergedParams;
    %{$mergedParams} = (%{$params},%{$superParams});
    $mergedParams->{'SpecificHosts'} = {          
            'order'             => $order++,
            'opt'               => 'specific_hosts',
            'type'              => 'csv',
            'section'           => $ini_section_general,
            'value'             => undef,
            'str'               => 'Specific Hosts',
            'desc'              => 'Update only in specific hosts',
            'skip'              => 0,
            'hidden'            => 0,
            'mandatory'         => 0,
            'set_interactive'   => 0
        };
     $mergedParams->{'HostagentPassword'}  = $self->getParamHostagentPassword ($order++, $ini_section_general);
     return $mergedParams;   
}

# HostagentPassword is set from within the source code, which means that it's pre-validated
sub checkHostagentPassword {
    my ($self, $value) = @_;
    return 1;
}

sub setRemoteHosts{
	my ( $self, $remoteHostsObjects) = @_;
	$self->{_remoteHosts} = $remoteHostsObjects;
	if(defined($remoteHostsObjects) && scalar(@{$remoteHostsObjects}) > 0){
		my $remoteHostNames = [];
		for my $remoteHosts (@{$remoteHostsObjects}){
			push(@{$remoteHostNames}, @{$remoteHosts->getHostNames()});
		}
		$self->{params}->{'CertificatesHostmap'}->{origin_values} = $remoteHostNames;
		$self->fillCertificatesHostmapDefaultValues();
	}
}

1;