package LCM::Configuration::LSS::LSSConfiguration;

use strict;
use SDB::Install::SysVars qw($isWin);
use SDB::Install::Globals qw($gShortProductNameLSS);
use SDB::Common::Utils qw(getSidcryptName checkOsUserID createUsername createGroupname checkOsGroupID);
use parent 'LCM::Configuration::GenericStackAny';

sub InitDefaults {
    my $self = shift();
    $self->SUPER::InitDefaults(@_);
    return 1;
}

sub defineLSSParams {
    my ($self) = @_;
    my $order = scalar keys %{ $self->{params} };
    my $section = 'lss';
    my $lssParams = {
        'LSSInstPath'    => getParamLSSInstPath( $order++, $section ),
        'LSSUserID'      => getParamLSSUserID( $order++, $section),
        'LSSGroupID'     => getParamLSSGroupID( $order++, $section ),
        'LSSUserHomeDir' => getParamLSSUserHomeDir( $order++, $section, '/usr/sap/$SID/lss/home' ),
        'LSSUserShell'   => getParamLSSUserShell( $order++, $section ),
    };
    map { $self->{params}->{$_} = $lssParams->{$_} } keys %$lssParams;
    return 1;
}

sub enableLSSParams {
    my ($self, $shouldEnable) = @_;

    $self->setSkip('LSSInstPath', !$shouldEnable);
    $self->setSkip('LSSUserID', !$shouldEnable);
    $self->setSkip('LSSGroupID', !$shouldEnable);
    $self->setSkip('LSSUserHomeDir', !$shouldEnable);
    $self->setSkip('LSSUserShell', !$shouldEnable);
}

sub initLSSUserID {
    my ($self, $freeUID) = @_;
    if (!defined $self->getBatchValue('LSSUserID')) {
        $self->setDefault('LSSUserID', $freeUID);
    }
}

sub initLSSGroupID {
    my ($self, $freeGID) = @_;
    if (!defined $self->getBatchValue('LSSGroupID')) {
        $self->setDefault('LSSGroupID', $freeGID);
    }
}

sub initLSSGroupAndUserID{
    my ($self) = @_;
    return 1 if($isWin);
    $self->initLSSUserID($self->getFreeOsUserID(undef, $self->getReservedUserIDs()));
    $self->initLSSGroupID($self->getFreeGroupID(undef, $self->getReservedGroupIDs()));
}

sub checkLSSUserID {
    my ($self, $value) = @_;
    my $userName = getSidcryptName($self->getValue('SID'));
    return 0 if(!checkOsUserID($self, 'LSSUserID' ,$userName, $value, 0)); # Cannot be in group 'sapsys'
    return $self->checkReservedOSUserIDs($value, 'LSSUserID');
}

sub checkLSSGroupID {
    my ($self, $value) = @_;
    my $sidcryptGroupName = getSidcryptName($self->getValue('SID'));
    return 0 if (!checkOsGroupID($self, 'LSSGroupID', $sidcryptGroupName, $value));
    return $self->checkReservedOSGroupIDs($value, 'LSSGroupID');
}

sub getLSSParams {
    return [ 'LSSInstPath', 'LSSUserID', 'LSSGroupID',
        'LSSUserHomeDir', 'LSSUserShell'];
}

sub areLSSParamsDefined {
    my ($self) = @_;
    my $areDefined = 1;
    my $lssParamIDs = $self->getLSSParams();
    foreach my $paramID (@$lssParamIDs){
        $areDefined &&= defined $self->{params}->{$paramID};
    }
    return $areDefined;
}

sub getParamLSSInstPath {
    my ( $order, $section ) = @_;

    return {
        'order'             => $order,
        'opt'               => 'lss_inst_path',
        'type'              => 'path',
        'section'           => $section,
        'value'             => undef,
        'default'           => '/lss/shared',
        'set_interactive'   => 1,
        'str'               => "Installation Path for $gShortProductNameLSS",
        'desc'              => "Installation Path for $gShortProductNameLSS",
        'skip'              => 1,
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}

sub getParamLSSUserID {
    my ( $order, $section, $sid ) = @_;

    return {
        'order'             => $order,
        'opt'               => 'lss_userid',
        'type'              => 'number',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'set_interactive'   => 1,
        'str'               => "$gShortProductNameLSS User ID",
        'str_templ'         => "$gShortProductNameLSS User (%s) ID",
        'desc'              => "$gShortProductNameLSS User ID",
        'skip'              => 1,
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}

sub getParamLSSUserHomeDir {
    my ( $order, $section, $default ) = @_;

    return {
        'order'             => $order,
        'opt'               => 'lss_user_home',
        'type'              => 'path',
        'section'           => $section,
        'value'             => undef,
        'default'           => $default,
        'set_interactive'   => 1,
        'str'               => "$gShortProductNameLSS User Home Directory",
        'desc'              => "$gShortProductNameLSS User Home Directory",
        'skip'              => 1,
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}

sub getParamLSSUserShell {
    my ( $order, $section ) = @_;

    return {
        'order'             => $order,
        'opt'               => 'lss_user_shell',
        'type'              => 'path',
        'section'           => $section,
        'value'             => undef,
        'default'           => '/bin/sh',
        'set_interactive'   => 1,
        'str'               => "$gShortProductNameLSS User Login Shell",
        'desc'              => "$gShortProductNameLSS User Login Shell",
        'skip'              => 1,
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}

sub getParamLSSGroupID {
    my ( $order, $section ) = @_;

    return {
        'order'             => $order,
        'opt'               => 'lss_groupid',
        'type'              => 'number',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'set_interactive'   => 1,
        'str'               => "$gShortProductNameLSS User Group ID",
        'desc'              => "$gShortProductNameLSS User Group ID",
        'skip'              => 1,
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}

1;