package LCM::Configuration::PersistenceInstallManager;

use strict;

use experimental qw (smartmatch);

use SDB::Install::SAPSystem qw ( CollectSAPSystems );
use SDB::Install::Globals qw ($gProductNameEngine);

use LCM::PersistencyUtils qw ( 	existsHdbinstPendingInstallOnly
								existsHdblcmPendingInstall
								existsHdbinstPendingInstall );

use base qw ( LCM::Configuration::PersistenceManager );

sub handlePendingInstall {
	my ($self, $sid) = @_;
	return $self->SUPER::handlePendingAction($sid);
}

sub handleHdbinstPendingInstall {
	my ($self, $sid) = @_;
	return $self->SUPER::handleHdbPendingAction($sid);
}

sub handleHdblcmPendingInstall {
	my ($self, $sid) = @_;
	return $self->SUPER::handleHdblcmPendingAction($sid);
}

sub getHdbToolName {
	return 'hdbinst';
}

sub existsHdbPendingAction {
	my ($self, $sid) = @_;
	return existsHdbinstPendingInstall($sid);
}

sub existsHdblcmPendingAction {
	my ($self, $sid, $target) = @_;
	return existsHdblcmPendingInstall($sid, $target);
}

sub existsHdbPendingActionOnly {
	my ($self, $sid) = @_;
	return existsHdbinstPendingInstallOnly($sid, $self->getConfiguration()->getValue('Target'));
}

sub _createHdbConfiguration{
	my ($self, $sid) = @_;

	return undef if (!defined $sid);

	my $allSystems = CollectSAPSystems();
	my $sapSystem = $allSystems->{$sid};
	require SDB::Install::Configuration::NewServerConfig;
	my $updConfig = new SDB::Install::Configuration::NewServerConfig();

	$updConfig->{optionIgnore} = $self->getConfiguration()->getOptionIgnore();

	$updConfig->{current_sid} = $sid;
	$updConfig->{sapSys}      = $sapSystem;

	return $updConfig;
}

sub _validateDetectedServerKitVersionPerAction {
	my ($self, $persistedVersion, $detectedVersion) = @_;
	my $configuration = $self->getConfiguration();
	my $sDetectedVersion = $detectedVersion->asString();
	my $sPersistedVersion = $persistedVersion->asString();
	my $pendingErrorMessage = $self->_getPendingErrorMessage($gProductNameEngine, $sDetectedVersion, $sPersistedVersion);

	if (!$persistedVersion->isEqual($detectedVersion)) {
		$configuration->getErrMsgLst->addError($pendingErrorMessage);
		return undef;
	}
	return 1;
}

1;
