package LCM::Configuration::PrintComponentListConfiguration;

use strict;
use LCM::Installer;
use SDB::Install::Globals qw($gProductNameEngine);

our $section = 'PrintComponentList';

our @ISA = qw (LCM::Configuration::GenericStackAny SDB::Install::Configuration::AnyConfig);

sub PRINT_COMPONENT_LIST_ACTION {"print_component_list"};

sub new{
    my $self = shift->SUPER::new (@_);
    
    my $order = 0;
    
    $self->{params} = {
    	'ShowHanaComponentsOnly' => $self->getParamShowHanaComponentsOnly($order++,$section),
    };

	if (!$self->initialize()) {
		return undef;
	}
	
    return $self;
}

sub getParamShowHanaComponentsOnly {
	my ($self, $order, $section, $action) = @_;
	
    my %paramShowHanaComponentsOnly = (
            'order'   => $order,
            'opt'     => 'show_hana_components_only',
            'type'    => 'boolean',
            'section' => $section,
            'value'   => undef,
            'default' => 0,
            'init_with_default' => 1,
            'str'     => "Shows only core HANA components (deprecated)",
            'set_interactive' => 0,
            'hidden'          => 1,
	);

    return \%paramShowHanaComponentsOnly;
}

sub initialize {
	my $self = shift;
	my $installer = new LCM::Installer();
	$installer->setMsgLstContext([$self->getMsgLst()]);
	my $scm = $installer->getOwnSystemComponentManager();
	$self->{systemComponentManager} = $scm;
	if (!defined $scm){
		$self->setErrorMessage("Cannot determine the installed '$gProductNameEngine'. Start the tool from its original location inside the database.");
		return undef;
	}
	
	return 1;
}

sub getSID {
	return $_[0]->{systemComponentManager}->getSid();
}

sub getSystemComponentManager {
	return $_[0]->{systemComponentManager};
}

sub getProductName{
    my $flavourProductName = $_[0]->getFlavourProductName();
    return $flavourProductName. " Components";
}

sub getAction{
	return PRINT_COMPONENT_LIST_ACTION;
}

1;
