package LCM::Configuration::RDSync::RDSyncConfiguration;

use strict;
use parent 'LCM::Configuration::GenericStackAny';
use SDB::Install::Globals qw ($gProductNameRDSync);
use LCM::Configuration::ParametersCreator qw ( defineConstraintOfHanaOptionParam );
use SDB::Install::SysVars;
use LCM::FileUtils;

our $section = 'rdsync';

sub getParamBasepathFileDownloadRDSync {
    my ($self, $order) = @_;
    return {
        'order'   => $order,
        'opt'     => 'rdsync_downloadpath',
        'type'    => 'path',
        'opt_arg' => '<path>',
        'section' => $section,
        'value'   => undef,
        'default' => '/hana/download_rdsync/$SID',
        'str'     => "Location of $gProductNameRDSync file download directory",
        'desc'    => "Location of $gProductNameRDSync file download directory",
        'skip'    => 1,
        'init_with_default' => 1,
        'set_interactive'   => 1,
        'mandatory'         => 1
    };
}

sub getParamBasepathFileUploadRDSync {
    my ($self, $order) = @_;
    return {
        'order'   => $order,
        'opt'     => 'rdsync_uploadpath',
        'type'    => 'path',
        'opt_arg' => '<path>',
        'section' => $section,
        'value'   => undef,
        'default' => '/hana/upload_rdsync/$SID',
        'str'     => "Location of $gProductNameRDSync file upload directory",
        'desc'    => "Location of $gProductNameRDSync file upload directory",
        'skip'    => 1,
        'init_with_default' => 1,
        'set_interactive'   => 1,
        'mandatory'         => 1
    };
}

sub defineRDSyncParams{
    my ($self) = @_;
    if (defined $self->{rdsyncParamsDefined}){
        return 1;
    }

    $self->{rdsyncParamsDefined} = 1;
    my $order = scalar keys %{ $self->{params} };
    $self->{paramIds} = undef;    # reset ordered id list cache
    
    my $rdsyncParams = {
	'BasepathFileDownloadRDSync' => defineConstraintOfHanaOptionParam($self->getParamBasepathFileDownloadRDSync ($order++), $gProductNameRDSync),
	'BasepathFileUploadRDSync'   => defineConstraintOfHanaOptionParam($self->getParamBasepathFileUploadRDSync ($order++), $gProductNameRDSync),
    };
    map { $self->{params}->{$_} = $rdsyncParams->{$_} } keys %$rdsyncParams;
}

sub enableRDSyncParams{
    my ($self, $on) = @_;
    if (!defined $on){
        $on = 1;
    }
    
    my $isUpdate = $self->isRDSyncUpdate();
    my $shouldSkipPaths = !$on || $isUpdate;
    
    $self->setSkip('BasepathFileDownloadRDSync', $shouldSkipPaths );
    $self->setSkip('BasepathFileUploadRDSync', $shouldSkipPaths );
    
    return 1;
}

sub checkBasepathFileDownloadRDSync {
    return $_[0]->checkHanaOptionsPathParam('BasepathFileDownloadRDSync', $_[1]);
}

sub checkBasepathFileUploadRDSync {
    return $_[0]->checkHanaOptionsPathParam('BasepathFileUploadRDSync', $_[1]);
}

sub isRDSyncUpdate{
    my ($self) = @_;
    my $rdsyncComponent = $self->{componentManager}->getComponentByBatchKey("rdsync");
    if (defined $rdsyncComponent && $rdsyncComponent->isComponentSelected() && $rdsyncComponent->isUpdate){
        return 1;
    }
    return 0;
}

sub isRDSyncNewInstall{
    my ($self) = @_;
    my $rdsyncComponent = $self->{componentManager}->getComponentByBatchKey("rdsync");
    if (defined $rdsyncComponent && $rdsyncComponent->isComponentSelected() && !$rdsyncComponent->isUpdate){
        return 1;
    }
    return 0;
}

1;
