package LCM::Configuration::SapAdmUser;

use SDB::Install::System;

use strict;

our @ISA = qw (SDB::Install::User);

sub new {
	my $self = shift->SUPER::new(@_);
	return $self;
}

sub verifyPasswordUx {
	my ($self, $passwd, $instconfig) = @_;

	if ( SDB::Install::System::isSidadmin($instconfig->getSID())) {
		return $self->verifyPasswordSHA($passwd, $instconfig);
	}

	return $self->SUPER::verifyPasswordUx($passwd);
}


# Returns:
# 1, if sapadm password is valid
# 0, if sapadm password is wrong
# undef, if verification failed, for example: no connection, SHA is not installed, etc
sub verifyPasswordSHA {
	my ($self, $passwd, $instconfig, $targetHosts) = @_;

	$instconfig->getMsgLst ()->addMessage ("Verifying $self->{name} password...");

	if (! defined $targetHosts) {
		$targetHosts = $self->_getVerificationHostnames($instconfig);
	}

	my $verificationHostnames = $targetHosts;
	my $username = $self->{name};
	my $useHttp = $instconfig->isUseHttps() ? 0 : 1 ;
	
	foreach my $host(@{$verificationHostnames}){
		my $hostctrl = new SDB::Install::SAPHostControl($host, $username, $passwd, $useHttp);

		$instconfig->getMsgLst ()->addMessage ("Executing saphostctrl function 'ListInstances' on '$host' ...");

		my $result = $hostctrl->ListInstances();
		my $errMsg = "Password verification failed on host '$host'";

		# The web service is not executed
		if (! defined $result) {
			my $errorMessage = $instconfig->setErrorMessage($errMsg);
			$errorMessage->getSubMsgLst ()->appendMsgLst ($hostctrl->getErrMsgLst());
			return undef;
		}

		# The web service returned fault
		if ((ref($result) eq "HASH") && (defined $result->{'faultstring'})) {
			my $serviceFaultString = $result->{'faultstring'};

			if( $serviceFaultString =~ '^.*Invalid\sCredentials.*'){
				$instconfig->setErrorMessage($errMsg . " : Unknown user password combination");
				return 0;
			}

			$instconfig->setErrorMessage($errMsg . " : " . $serviceFaultString);
			return undef;
		}
	}

	return 1;
}

sub _getVerificationHostnames {
	my ($self, $instconfig) = @_;

	my $verificationHostnames = $instconfig->getSystemHosts();
	my $additionalRemoteHostsObject = $instconfig->getAdditionalRemoteHosts();

	if(defined($additionalRemoteHostsObject)){
		push(@{$verificationHostnames}, @{$additionalRemoteHostsObject->getHostNames()});
	}

	return $verificationHostnames;
}

1;
