package LCM::Configuration::Validators::HanaOptionsPathValidator;

use strict;

use parent 'LCM::Configuration::Validators::Validator';
use LCM::FileUtils qw (GetPermissions);

my %pathParams = (
    'BasePathDataVolumes'        =>  'basepath_datavolumes',
    'BasePathLogVolumes'         =>  'basepath_logvolumes',
    'BasepathStreaming'          =>   undef,
    'EsDataPath'                 =>  'basepath_datavolumes_es',
    'EsLogPath'                  =>  'basepath_logvolumes_es',
    'AcceleratorDataPath'        =>  'basepath_datavolumes_ets',
    'AcceleratorLogPath'         =>  'basepath_logvolumes_ets',
    'BasepathFileDownloadRDSync' =>  'basepath_filedownload_rdsync',
    'BasepathFileUploadRDSync'   =>  'basepath_fileupload_rdsync'
    );

sub isValid {
    my ($self, $instconfig, $targetPathParam, $targetPath) = @_;

    return 1 if (! exists $pathParams{$targetPathParam});
    $targetPath =~ s/(\/|\\)+$//g; # remove trailing slashes

    my $basePathDataVolumesStr = SDB::Install::Configuration::NewServerConfig::getParamBasePathDataVolumes()->{str};
    my $basePathLogVolumesStr = SDB::Install::Configuration::NewServerConfig::getParamBasePathLogVolumes()->{str};
    my $isInstallation = $instconfig->isa('LCM::Configuration::GenericStackInstallConfiguration');

    foreach my $paramId ( keys %pathParams ) {
        next if ($paramId eq $targetPathParam);

        my $path = (!$instconfig->isSkipped($paramId)) ? $instconfig->getValue($paramId) : undef;

        if (!defined $path && !$isInstallation) {
            next if (! defined $pathParams{$paramId});

            # Component is already installed
            my $instance = $instconfig->getOwnInstance();
            my $global_ini = $instance->getGlobalIni();
            if (!defined $global_ini){
                $instconfig->AddWarning("Cannot open global.ini file");
                next;
            }
            $path = $global_ini->getValue ('persistence', $pathParams{$paramId});
        }
        next if (! defined $path);

        $path =~ s/(\/|\\)+$//g; # remove trailing slashes

        # In update_components action there are no BasePathDataVolumes & BasePathLogVolumes params in configuration
        my $pathDescription = undef;
        if ( $paramId eq 'BasePathDataVolumes' ) {
            $pathDescription = $basePathDataVolumesStr;
        } elsif ( $paramId eq 'BasePathLogVolumes' ) {
            $pathDescription = $basePathLogVolumesStr;
        } elsif ( defined $instconfig->{params}->{$paramId} ) {
            $pathDescription = $instconfig->getString($paramId);
        } else {
            $instconfig->AddWarning("Unknown parameter '$paramId");
            next;
        }

        # The new component path must not contains any other component path
        if( index($path, $targetPath) != -1){
            my $orContainStr = ($paramId =~ /BasePath.*Volumes/) ? '' : 'or contain ';
            my $message = sprintf("'%s' (%s) is invalid. It must not be the same as $orContainStr'%s' (%s).",
                $instconfig->getString($targetPathParam), $targetPath,
                $pathDescription, $path);
            $instconfig->AddError($message);
            return 0;
        }

        next if ($paramId eq 'BasePathDataVolumes'); # It is allowed that HANA data/log paths
        next if ($paramId eq 'BasePathLogVolumes');  # contain the component ones

        # The new component path must not be contained in any other component path (except of HANA data/log paths)
        if( index($targetPath, $path) != -1){
             my $message = sprintf("'%s' (%s) is invalid. It must not be the same or contained by '%s' (%s).",
                $instconfig->getString($targetPathParam), $targetPath,
                $instconfig->getString($paramId), $path);
            $instconfig->AddError($message);
            return 0;
        }
    }
    return 1;
}


1;
