package LCM::Configuration::ValueChangeListeners::AddHostRoles::RemoteCredentialsListener;
use strict;

sub new {
    my ($class) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}

sub onMapValueChange{
    my ($self, $valKey, $value, $configuration) = @_;
    my $isAddingRemoteRoles = $configuration->isAddingAdditionalRemoteRoles();
    my $isUsingSHA = $configuration->isUseSAPHostagent();
    my $shouldSkipRootCredentials = (!$isAddingRemoteRoles || $isUsingSHA) ? 1 : 0;

    $configuration->setSkip('RootUser', $shouldSkipRootCredentials);
    $configuration->setSkip('RootPassword', 1); # checKRootUser will unskip if needed
    return 1;
}

1;
