package LCM::Configuration::ValueChangeListeners::AdditionalHostsListener;

use strict;
use LCM::Component;
use SDB::Install::Globals qw ($gSpecificHostsRolesRegex);

sub new { return bless({}, $_[0]); }

sub onValueChange {
	my ($self, $value, $instconfig) = @_;

	$instconfig->initRecommendationTexts();
	$instconfig->setSkip('AutoAddXS2Roles', $instconfig->_shouldSkipAutoAddXS2Roles());
	$instconfig->setAddHostsFilterRegex($gSpecificHostsRolesRegex);

	return 1;
}

1;
