package LCM::Configuration::ValueChangeListeners::CertificatesSkipValueConfigurator;

use strict;
use  LCM::Executors::CheckCertificatesExecutor;
use SDB::Install::System qw(isSidadmin);
use SDB::Install::Configuration qw($bool_true_pattern);

sub new {
    my ($class, ) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}

sub configureSkippingCertificates {
    my ($self, $instconfig) = @_;
    my $addHosts      = $instconfig->getValue('AddHosts');
    my $isAddingHosts = (! $instconfig->isSkipped('AddHosts'))
                        && defined $addHosts &&  (length($addHosts) > 0);
    my $isInstallingSHA = ($instconfig->getValue('InstallHostagent') =~ /$bool_true_pattern/);

    return unless($isInstallingSHA && ($instconfig->getComponentManager()->isHDBServerComponentSelected() || $isAddingHosts) );

    my $sid = $instconfig->getSID();
    my $isUseSha = $instconfig->isUseSAPHostagent();
    my $isUpdate = $instconfig->can('isUpdate') && $instconfig->isUpdate();

    return if ($isUpdate && ($isUseSha || isSidadmin($sid)));

    my $checkCertificatesExecutor = new LCM::Executors::CheckCertificatesExecutor($instconfig);
    my $rc = $checkCertificatesExecutor->execute();
    my $skipFlag = $rc ? 0 : 1;

    $instconfig->setSkip('CertificatesHostmap', $skipFlag);
}

1;