package LCM::Configuration::ValueChangeListeners::CheckLocalSystemRequirementsListener;
use strict;

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    my $instance = $instconfig->getOwnInstance();
    my $newDbConfig   = SDB::Install::Configuration::NewDB->new();
    $newDbConfig->setOptionIgnore($instconfig->getOptionIgnore());
    $newDbConfig->setMsgLstContext($instconfig->getMsgLstContext());
    my $sysinfo       = $instconfig->getSysInfo();
    my $manifest      = $instance->getManifest();
    return $newDbConfig->checkSystemRequirements($sysinfo, $manifest);
}
1;
