package LCM::Configuration::ValueChangeListeners::ComponentListener;

use strict;
use base qw(LCM::Configuration::ValueChangeListeners::ComponentLocationListener);

sub new {
    my ($class, $componentScanner, $parametarName) = @_;
    my $self = $class->SUPER::new(@_);
    $self->{componentScanner} = $componentScanner;
    $self->{parametarName} = $parametarName;
    return $self;
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;

    if ( !$self->SUPER::onValueChange($value, $instconfig)) {
        return 0;
    }

    my $mediumCmpMgr = $instconfig->getComponentManager();
    my $canPrint = $mediumCmpMgr->canPrintDetectedComponents();

    $mediumCmpMgr->setCanPrintDetectedComponents(0);
    my $param = $instconfig->{params}->{$self->{parametarName}};
    if ($self->{componentScanner}->scan($self->{parametarName},$value)){
        $instconfig->appendErrorMessage ("$param->{str} '$value' is invalid", $self->{componentScanner}->getErrMsgLst ());
        $mediumCmpMgr->setCanPrintDetectedComponents($canPrint);
        return undef;
    }

	if ($instconfig->can('initializeSelectedComponents')
		&& !$instconfig->initializeSelectedComponents()) {
		$instconfig->setNoRetry($self->{parametarName},1);
        $mediumCmpMgr->setCanPrintDetectedComponents($canPrint);
		return undef;
	}
    $mediumCmpMgr->setCanPrintDetectedComponents($canPrint);

    return 1;
}

1;