package LCM::Configuration::ValueChangeListeners::ConvertToMultiDB::NoStartListener;

use strict;
use SDB::Install::Configuration qw($bool_false_pattern);

sub new { return bless({}, shift()); }

sub onValueChange {
	my ($self, $value, $configuration) = @_;
	my $willStartDb = ($value =~ /$bool_false_pattern/);
	my $skipImportContent = $willStartDb ? 0 : 1;
	my $skipNoStartTenantDb = $willStartDb ? 0 : 1;

	$configuration->setSkip('ImportContent', $skipImportContent);
	$configuration->setSkip('NoStartTenantDB', $skipNoStartTenantDb);
	return 1;
}

1;