package LCM::Configuration::ValueChangeListeners::DownloadComponents::WebServiceConnectionListener;

use strict;
use LCM::FileUtils qw(MyRealPath);
use SDB::Install::System qw(loadSSLRequiringPackage);
use SDB::Install::Configuration qw($bool_true_pattern);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $isDownloadingOnHANA = $value =~ /$bool_true_pattern/;
    my $shallSkipProxyParameters = !$isDownloadingOnHANA || $self->_hasOutboundConnectivity($configuration) ? 1 : 0;

    for my $parameterId ('ProxyHost', 'ProxyPort', 'UseProxyAuthorization', 'ProxyUser', 'ProxyPassword'){
        $configuration->setSkip($parameterId, $shallSkipProxyParameters);
    }
    return 1;
}

sub _hasOutboundConnectivity {
    my ($self, $configuration) = @_;
    my $webServiceProxyURL = $configuration->getValue('WebServiceProxyURL');
    $webServiceProxyURL =~ s/\/$//;
    my $indexPageURL = sprintf('%s/%s', $webServiceProxyURL, 'index.html');
    my ($webServiceHost) = $webServiceProxyURL =~ m!^https?://([^/:]+)/!;
    my $caPath = MyRealPath($configuration->getValue('CAPath'));
    my $response = undef; # undef by default

    return undef if (!loadSSLRequiringPackage ('LWP::Protocol::https', $configuration->getMsgLst (), $configuration->getErrMsgLst ()));
    require LCM::Utils::TCPUserAgent;

    eval {
        local $SIG{__DIE__} = 'DEFAULT';
        my $userAgent = new LCM::Utils::TCPUserAgent($caPath);
        $response = $userAgent->get($indexPageURL);
    };
    my $isTLSv1_2Error = defined($response) && $response->code() == 500 && ($response->decoded_content() =~ /error:14077410:SSL/);

    $configuration->clearParameterWarnings("DownloadOnHANA");
    if($@ || (!$isTLSv1_2Error && !$response->is_success())){
        my $suffix = defined($@) && length($@) ? $@ : $response->status_line();
        my $warningMessage = sprintf('Cannot establish connection to host \'%s\': %s', $webServiceHost, $suffix);
        $configuration->addParameterWarning("DownloadOnHANA", $warningMessage);
        $configuration->getMsgLst()->addWarning($warningMessage);
        return undef;
    }
    return 1;
}

1;