package LCM::Configuration::ValueChangeListeners::Install::AutoAddXsRolesListener;

use strict;
use LCM::Component;
use SDB::Install::Configuration qw($bool_true_pattern);

sub new { return bless({}, $_[0]); }

sub onValueChange {
	my ($self, $value, $instconfig) = @_;
	my $isAddingHosts = defined($instconfig->getValue('AddHosts')) && !$instconfig->isSkipped('AddHosts');
	my $isAutoAddEnabled = ($value =~ /$bool_true_pattern/) ? 1 : 0;

	if($isAddingHosts && $isAutoAddEnabled) {
		$instconfig->setAddHostsFilterRegex('.+');
	}

	return 1;
}

1;
