package LCM::Configuration::ValueChangeListeners::Install::DbModeListener;

use strict;
use SDB::Install::Globals qw ($gKeynameStreaming);

sub new {
	return bless({}, shift());
}

sub onValueChange {
	my ($self, $value, $configuration) = @_;
	my $isMultiDb = ($value eq 'multidb');
	my $componentManager = $configuration->getComponentManager();
	my $isInstallingStreaming = $componentManager->isComponentSelected($gKeynameStreaming);
	my $shouldSkipStreamingPassword = ($isInstallingStreaming && !$isMultiDb) ? 0 : 1;

	$configuration->setSkip('StreamingClusterManagerPassword', $shouldSkipStreamingPassword);
	return 1;
}

1;