package LCM::Configuration::ValueChangeListeners::Install::SIDListener;

use strict;
use File::Spec;
use LCM::App::ApplicationContext;
use LCM::Configuration::NewDBUser::NewDBUser;
use SDB::Install::SysVars qw ($isWin $path_separator);
use LCM::Configuration::ValueChangeListeners::Install::SIDHelper;
use SDB::Install::Globals qw($gKeynameLSS);

sub new {
	return bless({}, shift());
}

sub onValueChange {
	my ($self, $value, $config) = @_;

	if ( defined $config->{params}->{Password} ) {
		if (! LCM::Configuration::ValueChangeListeners::Install::SIDHelper::InitConfigUsername($config, $value)) {
			return 0;
		}
		my $user = new LCM::Configuration::NewDBUser::NewDBUser($value);
		my $userExists = $isWin ? $user->existsWin() : $user->existsUx();
		$config->setType('Password', $userExists ? 'passwd' : 'initial_passwd');
		$config->setSkip('Password', 0);
	}

	$config->_recomputeRequiredAcceleratorParams();

# Call to defineLog is needed in order to remain consistent in terms of log directories names in update/installation scenarios
# where the SID is not known in advance. For additional information see Bug 65517
	my $applicationContext = LCM::App::ApplicationContext::getInstance();
	my $action = $config->getAction();
	my $check_only = ( defined $config ) ? $config->isCheckOnly() : 0;
	$applicationContext->getApplication()->defineLog( "hdblcm_$action", 'hdblcm', $check_only, $value, 1);

	# Internal Incident: TC:HANA:SP10:R - Change SID and Logs and Data folder Remain unchanged
	if ( defined $config->{params}->{BasePathDataVolumes} ) {
		$config->{params}->{BasePathDataVolumes}->{value} = undef;
		if ($self->_isConfigFileValueDefault($config, 'BasePathDataVolumes', $value)) {
			$config->{params}->{BasePathDataVolumes}->{batchValue} = undef;
		}
	}

	if ( defined $config->{params}->{BasePathLogVolumes} ) {
		$config->{params}->{BasePathLogVolumes}->{value} = undef;
		if ($self->_isConfigFileValueDefault($config, 'BasePathLogVolumes', $value)) {
			$config->{params}->{BasePathLogVolumes}->{batchValue} = undef;
		}
	}
	for my $parameterId ('HomeDir', 'EsDataPath', 'EsLogPath', 'BasepathFileDownloadRDSync', 'BasepathFileUploadRDSync', 'AcceleratorDataPath', 'AcceleratorLogPath', 'BasepathStreaming'){
		next if (!defined($config->{params}->{$parameterId}));
		next if (! $self->_isConfigFileValueDefault($config, $parameterId, $value));

		$config->{params}->{$parameterId}->{batchValue} = undef;
	}


    my $sharedDir = $config->getValue('Target');
    my $defaultXsEaDataPath = File::Spec->catfile($sharedDir, $value, 'xs', 'app_working');
    my $defaultRefDataPath  = File::Spec->catfile($sharedDir, $value, 'global', 'hdb', 'IM' ,'reference_data');

    $config->setDefault('XsEaDataPath', $defaultXsEaDataPath);
    if (!$config->isSkipped('ReferenceDataPath')){
        $config->setDefault('ReferenceDataPath', $defaultRefDataPath);
    }

    $config->tryInitGroupAndUserID();
    $config->initLSSGroupAndUserID() if($config->_isComponentSelected($gKeynameLSS));
	return 1;
}

# Checks if parameter in configuration file (with ${SID} placeholder) is with default value that uses wrong SID.
# Should be removed after refactoring of configuration file handling (parameters should be set after validation).
sub _isConfigFileValueDefault {
	my ($self, $config, $paramId, $sid) = @_;

	if (!defined $config->{config_file}) {
		return 0;
	}

	my $configFileSID = $config->getValueFromConfigfile('SID');

	# SID in configuration file is validated
	if ($sid eq $configFileSID) {
		return 0;
	}

	my $param = $config->{params}->{$paramId};

	# Batch value is provided via cmd line.
	if (defined $param->{opt}) {
		my $optValue = $config->{options}->{$param->{opt}};
		if (defined $optValue) {
			return 0;
		}
	}

	my $configFileValue = $config->{params}->{$paramId}->{batchValue}; # config file value is assigned to $param->{batchValue}
	my $default = $config->getDefault($paramId);

	if (!defined $configFileValue || !defined $default) {
		return 0;
	}

	my $pattern = '\$\{SID\}|\$SID|\$\{sid\}|\$sid';
	if ($default =~ $pattern) {
		$default =~ s/$pattern/$configFileSID/g;
	}

	if ($configFileValue eq $default) {
		return 1;
	}

	return 0;
}

1;