package LCM::Configuration::ValueChangeListeners::Install::SelectedComponentsListener;

use strict;
use LCM::Component;
use parent 'LCM::Configuration::ValueChangeListeners::InstallUpdate::SelectedComponentsListenerBase';
use SDB::Install::Globals qw ($gKeynameStreaming $gKeynameEs $gKeynameAccelerator $gKeynameRDSync $gKeynameXS2 $gKeynameLSS);

sub new {
	return bless({}, shift());
}

sub onValueChange {
	my ($self, $selectedCmpsValue, $instconfig) = @_;

	return undef if(! $self->SUPER::onValueChange($selectedCmpsValue, $instconfig));

	my $isPostServerPendingInstall = $instconfig->isPostServerResumeInstallation();
	my $hasAddLocalRolesPersistedValue = defined $instconfig->getPersistedValue('AddLocalRoles');
	my $skipAddLocalRoles = $isPostServerPendingInstall && $hasAddLocalRolesPersistedValue ? 0 : $self->_shallSkipAddLocalRoles($instconfig);
	my $applicableOnInstallComponentsWarning = 'It is applicable only when installing components.';
	$instconfig->setSkip('AddLocalRoles', $skipAddLocalRoles, $applicableOnInstallComponentsWarning);

	if ( $isPostServerPendingInstall ){
		my $hasAddHostsPersistedValue = defined $instconfig->getPersistedValue('AddHosts');
		$instconfig->setSkip('AddHosts', ! $hasAddHostsPersistedValue);
		if (!$instconfig->isUseSAPHostagent()) {
			$instconfig->setSkip('RootUser', 0);
		}
	}

	my $persistenceManager = $instconfig->getPersistenceManager();
	return undef if (!$persistenceManager->validateDetectedServerKitVersion());

	$self->addResumeActionProgressMsg($instconfig);
	$self->_handleDefaultTenantUserCredentials($instconfig);
	$instconfig->enableHostagentPasswordIfRequired();
	return 1;
}

sub addResumeActionProgressMsg {
	my ($self, $configuration) = @_;

	if ($configuration->getComponentManager()->existsSelectedComponentInPendingState($configuration)) {
		my $pendingComponent = $self->_getPendingComponent($configuration);
		return if ! defined $pendingComponent;

		my $persistedXmlObject = $pendingComponent->getPersistenceXMLObject($configuration);
		my $pendingStepName = $persistedXmlObject->getCurrentStepString();
		$configuration->AddProgressMessage ("Resuming pending " . $configuration->getAction() . " at step '${pendingStepName}'");
	}
}

sub _getPendingComponent {
	my ($self, $configuration) = @_;
	my $componentManager = $configuration->getComponentManager();
	my $selectedComponents = $componentManager->getSelectedComponents();
    my $xs2Application = new LCM::Component::Installable::XS2Application(undef, undef, $configuration);
    push @$selectedComponents, $xs2Application;

	for my $selectedComponent (@{$selectedComponents}) {
		if ($selectedComponent->can('hasPersistenceFile') && $selectedComponent->hasPersistenceFile($configuration)) {
			return $selectedComponent;
		}
	}
	return undef;
}

sub _shallSkipAddLocalRoles {
	my ($self, $instconfig) = @_;

	my $componentManager = $instconfig->getComponentManager();
	for my $componentKeyname ($gKeynameStreaming, $gKeynameEs, $gKeynameAccelerator, $gKeynameRDSync, $gKeynameXS2) {
		my $component = $componentManager->getComponentByKeyName($componentKeyname);

		return 0 if(defined($component) && $component->isComponentSelected());
	}
	return 1;
}

sub _initISCModeDefaultValue {
	my ($self, $configuration) = @_;
	my $componentManager = $configuration->getComponentManager();
	my $xsComponent = $componentManager->getComponentByKeyName($gKeynameXS2);
	my $isXsSelected = (defined($xsComponent) && $xsComponent->isComponentSelected());
	my $defaultValue = $isXsSelected ? 'ssl' : 'standard';

	$configuration->setDefault('ISCMode', $defaultValue, 1);
}

1;
