package LCM::Configuration::ValueChangeListeners::InstallUpdate::HandleExistingLSSUserAndGroupListener;

use strict;
use SDB::Common::Utils qw(createGroupname createUsername);
use SDB::Install::Globals qw($gKeynameLSS);

sub new {
    my ($class) = @_;
    my $self = bless({}, shift());
    return $self;
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $lssComponent = $configuration->getComponentManager()->getComponentByKeyName($gKeynameLSS);
    if ( defined $lssComponent && $lssComponent->isComponentSelected() && !$lssComponent->isUpdate()) {
        if(!$self->handleExistingLssUser($configuration)){
            $configuration->setNoRetry('InstanceNumber', 1);
            return 0;
        }
        if(!$self->handleExistingLssGroup($configuration)){
            $configuration->setNoRetry('InstanceNumber', 1);
            return 0;
        }
    }

    return 1;
}

sub handleExistingLssUser {
    my ($self, $configuration) = @_;
    my $username = createUsername('LSSUserID', $configuration->getValue('SID'));
    my $existingId = $configuration->getExistingUserId($username);
    if(defined($existingId)){
        return $configuration->handleExistingOsID($existingId, 'LSSUserID');
    }
    return 1;
}

sub handleExistingLssGroup {
    my ($self, $configuration) = @_;
    my $groupname = createGroupname('LSSGroupID', $configuration->getValue('SID'));
    my $existingId = $configuration->getExistingGroupId($groupname);
    if(defined($existingId)){
        return $configuration->handleExistingOsID($existingId, 'LSSGroupID');
    }
    return 1;
}

1;
