package LCM::Configuration::ValueChangeListeners::InstallUpdate::LSSUserStringListener;

use strict;
use LCM::App::ApplicationContext;
use SDB::Common::Utils qw(getSidcryptName);

sub new { return bless({}, shift()); }

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $applicationContext = LCM::App::ApplicationContext::getInstance();
    my $username = getSidcryptName($configuration->getSID());
    if($applicationContext->getMode() =~ /^CLI|Batch$/){
        my $parameter = $configuration->{params}->{LSSUserID};
        if(defined($parameter) && defined($parameter->{str_templ})){
            $parameter->{str} = sprintf($parameter->{str_templ}, $username);
        }
    }
    return 1;
}

1;
