package LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationBatchListener;

use strict;
use warnings;
use SDB::Install::Globals qw($gFailedSignatureVerificationMessage);
use parent 'LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationListenerBase';

sub new {
    return bless({}, shift());
}

sub handleSapdsignerLogging {
    my ($self, $sapdsigner, $instconfig) = @_;
    if ($instconfig->getIgnore('verify_signature') && $instconfig->canIgnoreVerificationFailure(0)) { # 0 - not verbose
        my $configMsgLst = $instconfig->getMsgLst();
        $sapdsigner->setMsgLstContext([ $configMsgLst, $configMsgLst ]);
    } else {
        $self->SUPER::handleSapdsignerLogging($sapdsigner, $instconfig);
    }
}

sub handleVerificationFailure {
    my ($self, $instconfig) = @_;
    $instconfig->getErrMsgLst()->addError("Signature verifiction for the selected components failed");
    $instconfig->getErrMsgLst()->addError($gFailedSignatureVerificationMessage);
    $instconfig->getErrMsgLst()->addError("To ignore component authentication failures, use the --ignore=verify_signature switch.");
    return 0;
}

1;
