package LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationCLIListener;

use strict;
use warnings;
use parent 'LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationListenerBase';
use SDB::Install::Tools;
use SDB::Install::Globals qw($gFailedSignatureVerificationMessage $gSAPDSignerNotDetectedMessage $gFailedVerificationMessage);
use LCM::SAPDSigner;

sub new {
    return bless({}, shift());
}

sub handleSapdsignerLogging {
    my ($self, $sapdsigner, $instconfig) = @_;
    my $isUpdateBootstrap = LCM::Installer->new()->isInstalled() && $instconfig->getAction() eq 'update';
    if ($instconfig->isPendingInstallation() || $isUpdateBootstrap ) {
        $self->SUPER::handleSapdsignerLogging($sapdsigner, $instconfig);
    } else {
# Force SAPDSigner to append error messages to the MsgLst instead of ErrMsgLst
# so that if the user selects 'n' on askConfirmation, the errors don't appear
# on the console after the confirmation
        my $configMsgLst = $instconfig->getMsgLst();
        $sapdsigner->setMsgLstContext([ $configMsgLst, $configMsgLst ]);
    }
}

sub handleVerificationFailure {
    my ($self, $instconfig) = @_;
    my $authenticationFailures = $self->getVerificationErrors();
    my $hasAuthenticityErrors = grep{ $_->isVerificationAuthenticityError()} @{$authenticationFailures};
    my $failedComponents = scalar(@{$authenticationFailures});
    if ($failedComponents > 1) {
        my %failedComponents = map { $_->getComponentName() => 1 } @{$authenticationFailures};
        my $msg = $hasAuthenticityErrors ? "Authenticity verification of the following components failed:" : "Verification of the following components failed:";
        $instconfig->getMsgLst()->addProgressMessage($msg);
        $instconfig->getMsgLst()->addProgressMessage((' ' x 2).$_->getMultipleFailedComponentsMessage()) for @{$authenticationFailures};
    }
    elsif($failedComponents == 1) {
            $instconfig->getMsgLst()->addProgressMessage($authenticationFailures->[0]->getSingleFailedComponentMessage());
    }

    my $confirmationMsg = $hasAuthenticityErrors ? "$gFailedSignatureVerificationMessage" : "$gFailedVerificationMessage";
    return SDB::Install::Tools::askConfirmation($confirmationMsg.' Do you want to continue?', 'n');
}

1;
