package LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationGUIListener;

use strict;
use warnings;
use parent 'LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationListenerBase';
use LCM::App::ApplicationContext;
use LCM::Gui::Dialogs::ConfigurationExecutionProgressHandler;
use LCM::SAPDSigner;

use Wx qw(wxICON_ERROR wxCENTRE wxCANCEL wxOK wxID_OK);

sub new {
    return bless ({}, shift());
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    my $rc = $self->SUPER::onValueChange($value, $instconfig);
    if (!$rc && !$instconfig->canIgnoreVerificationFailure(0)) { # 0 - not verbose
        my $app = LCM::App::ApplicationContext::getInstance()->getApplication();
        $app->getGUIWizard()->getCurrentDialog()->showConfigurationErrors();
        return 0;
    }
    return $rc;
}

sub verifyComponentAuthenticity {
    my ($self, $instconfig) = @_;
    return 1 if (!$instconfig->getValue('VerifySignature'));

# Add Progress bar during verification to current dialog
    my $app = LCM::App::ApplicationContext::getInstance()->getApplication();
    my $wizard = $app->getGUIWizard();
    my $currentDialog = $wizard->getCurrentDialog();
    $currentDialog->addProgressSizer();
    $currentDialog->showSAPDSignerProgressSizer(1);
    $currentDialog->enableNonProgressSizerUIControls(0);

    my $sapdsigner = LCM::SAPDSigner->getInstance();
    if (defined $sapdsigner) {
        my $progressHandler = LCM::Gui::Dialogs::ConfigurationExecutionProgressHandler->new($currentDialog, $currentDialog->getProgressMessageLabel());
        $sapdsigner->setProgressHandler($progressHandler);
    # ======================================================
        my $rc = $self->SUPER::verifyComponentAuthenticity($instconfig);
        $currentDialog->showSAPDSignerProgressSizer(0);
        return 1 if ($rc);
    }

    $currentDialog->enableNonProgressSizerUIControls(1);
    return 0;
}

sub handleVerificationFailure {
    my ($self, $instconfig) = @_;
    my $app = LCM::App::ApplicationContext::getInstance()->getApplication();
    my $wizard = $app->getGUIWizard();
    my $caption = "Failed authenticity verification";
    my $errorMessage = $self->getFailedVerificationMessage();
    my $ignoreErrorsDialog = Wx::MessageDialog->new($wizard, $errorMessage, $caption, wxICON_ERROR | wxCENTRE | wxCANCEL | wxOK);
    $ignoreErrorsDialog->SetOKCancelLabels('Ignore', 'Back');
    my $choice = $ignoreErrorsDialog->ShowModal();
    return ($choice == wxID_OK) ? 1 : 0;
}

1;