package LCM::Configuration::ValueChangeListeners::InstallUpdate::XSSpaceIsolationStringListener;

use strict;
use LCM::App::ApplicationContext;

sub new { return bless({}, shift()); }

sub onValueChange {
	my ($self, $value, $configuration) = @_;
	my $applicationContext = LCM::App::ApplicationContext::getInstance();

	if($applicationContext->getMode() =~ /^CLI|Batch$/){
		my $parameter = $configuration->{params}->{XSSpaceIsolation};

		if(defined($parameter) && defined($parameter->{str_templ})){
			$parameter->{str} = sprintf($parameter->{str_templ}, $value);
		}
	}
	return 1;
}

1;
