package LCM::Configuration::ValueChangeListeners::PostCollectHostInfoChecksListener;

sub new {
	my ($class) = @_;
	my $self = {};
	bless $self, $class;
	return $self;
}

sub onValueChange {
	my ($self, $value, $config) = @_;
	return $self->checkCollectedHostInfo($config);
}

sub checkCollectedHostInfo {
	my ($self, $config) = @_;
	my $sidValue = $config->getValue('SID');
# validateSidBasedOnRemoteSidadms can end up calling
# the checkUID method if the user already exists on the
# host to be added. It will not behave properly if
# $config->{current_sid} is not set
	$config->{current_sid} = $config->{current_sid} // $sidValue;
	if (! $config->validateSidBasedOnRemoteSidadms($sidValue)) {
		return 0;
	}
	my $instance = $config->getOwnInstance();
	my $instanceNumber = $instance->get_nr();
	if (! $config->checkAdditionalInstanceNumber($instanceNumber, 'Instance Number', $sidValue)) {
		return 0;
	}
	return 1;
}

1;
