package LCM::Configuration::ValueChangeListeners::PrepareExecutionEnvironmentListener;

use strict;
use SDB::Install::System qw (isSidadmin);
use LCM::Fcgi::App::EnvironmentUtilities;

sub new {
	return bless({}, shift());
}

# Value is the current selected sid in case of nonresident update
sub onValueChange {
	my ( $self, $value, $config) = @_;

# Explicitly prepare execution environment for sidadm execution cases
	PrepareExecutionEnvironment($value) if(isSidadmin($value));

	return 1;
}

1;