package LCM::Configuration::ValueChangeListeners::Rename::SystemRestartParamListener;

use strict;
use LCM::App::ApplicationContext;
use SDB::Install::Globals qw(getFlavourProductName $gFlavourPlatform);
use LCM::Task qw($gFlavourProductName);
my $RESTART_OF_SYSTEM_WRN = "$gFlavourProductName System will be restarted";
my $STOP_OF_SYSTEM_WRN = "$gFlavourProductName System will be stopped";

sub new {
    my ($class, $param, $checkContinueOption) = @_;
    my $self = {
        param => $param,
        checkContinueOption => $checkContinueOption,
    };
    return bless($self,$class);
}

sub isPathParamChanged {
    my ($self, $instconfig) = @_;
    return $instconfig->getType($self->{param}) eq 'path';
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    $self->_addRestartWarning($instconfig);
    return 0 if $self->isPathParamChanged($instconfig) && !$instconfig->checkHanaOptionsPathParam($self->{param}, $value);
    return 1;
}

sub onMapValueChange {
    my ($self, $valKey, $value, $instconfig) = @_;
    $self->_addRestartWarning($instconfig);
    return 1;
}

sub _addRestartWarning {
    my($self,$instconfig) = @_;
    my $isNostart = $instconfig->getValue('NoStart');
    my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
    my $message = $isNostart ? $STOP_OF_SYSTEM_WRN : $RESTART_OF_SYSTEM_WRN;
    $message =~ s/\Q$gFlavourProductName\E/$flavourProductName/g;
    my $isMessageAdded = grep {$_ eq $message} @{$instconfig->{warnings}};

    return if($isMessageAdded);
    return if($self->{checkContinueOption});
    return if($instconfig->{isContinueOption});

    push(@{$instconfig->{warnings}}, $message);
}

1;