package LCM::Configuration::ValueChangeListeners::Rename::TargetListener;
use SDB::Install::SysVars qw($path_separator $isWin);

sub new {
	my ( $class ) = @_;

	my $self = {};
	bless $self, $class;

	return $self;
}

sub onValueChange {
	my ( $self, $value, $instconfig ) = @_;
	my $rc = 1;
	#
    # If the user have prepared all required manual steps for rename of the system mountpoint,
    # the detected source SID is actually the target SID.
    #
    my $originallyDetectedSourcetSid = $instconfig->getSid ();
    #
    # Read the actual source SID from the HDB profile file.
    #
    my $actualSourceSid = $instconfig->readSIDFromProfileFile ( $value, $originallyDetectedSourcetSid );
    if(! defined $actualSourceSid) {
        return undef;
    }    
    my $isSidMountpoint = $actualSourceSid ne $originallyDetectedSourcetSid;
	
	if ( $isSidMountpoint ) {	
        $rc = $instconfig->setCorrectSidValuesInSidMountpointScenario ( $value, $originallyDetectedSourcetSid, $actualSourceSid );
	}
	
	if (!$instconfig->isUseSAPHostagent()){
	   $instconfig->ensureRootCredentialsIfNeeded() if (defined $rc);
	}

	return $rc;
}

1;
