package LCM::Configuration::ValueChangeListeners::ReservedIDsHandler;

use strict;
use SDB::Install::Globals qw($gKeynameLSS);
use SDB::Install::SysVars qw($isWin);

sub new {
    my ($class, $paramId, $isUID) = @_;
    my $self = bless( {}, shift );
    $self->{paramID} = $paramId;
    $self->{isUID} = $isUID;
    return $self;
}

sub onValueChange {
    my ($self, $value, $config) = @_;
    return 1 if($isWin);

    my $paramID = $self->{paramID};
    if ($self->{isUID}){
        $config->addReservedUserID($paramID, $value);
    } else {
        $config->addReservedGroupID($paramID, $value);
    }

    if ($paramID eq 'UID' && $config->_isComponentSelected($gKeynameLSS)){
        $config->initLSSUserID($config->getFreeOsUserID(undef, $config->getReservedUserIDs()));
    }
    if ($paramID eq 'GID' && $config->_isComponentSelected($gKeynameLSS)){
        $config->initLSSGroupID($config->getFreeGroupID(undef, $config->getReservedGroupIDs()));
    }
    return 1;
}

sub configurationChanged {
    my ($self, $event) = @_;
    return if (! defined $event || $event->{property} ne 'skip');

    my $userPattern = '(^UID$|UserI[dD])';
    my $groupPattern = '(^GID$|GroupI[dD])';
    if($event->{newValue} == 1 && $event->{paramId} =~ /$userPattern/){
        $event->{config}->deleteUnnesessaryReservedUserIDs();
    } elsif($event->{newValue} == 1 && $event->{paramId} =~ /$groupPattern/) {
        $event->{config}->deleteUnnesessaryReservedGroupIDs();
    }
}

1;
