package LCM::Configuration::ValueChangeListeners::Uninstall::SelectedComponentsListener;

use strict;
use SDB::Install::Globals qw ( $gKeynameEngine );
use LCM::Utils::RemoveHosts qw(IsRemovingLocalHost IsRemovingRemoteHost);
use LCM::Utils::RemoveRoles qw(IsRemovingLocalRole IsRemovingRemoteRole);

####
# Important - if changed - changes might apply to the Web::SelectedComponentsListener as well
####

sub new { return bless({}, shift()); }

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $sapSys = $configuration->getSAPSystem(1);
    my $target = $sapSys->get_target();

    $configuration->setValue('Target', $target);
    $configuration->_recalculateRolesForRemoval();
    $configuration->_recalculateHostsForRemoval();

    my $shallSkipForceOption = $self->_shallSkipForce($configuration);
    $configuration->setSkip('ForceRemoveHosts', $shallSkipForceOption);

    my $shallSkipKeepUser = $self->_shallSkipUserParameters($configuration);
    $configuration->setSkip('KeepUser', $shallSkipKeepUser);
    $configuration->setSkip('KeepUserHomeDir', $shallSkipKeepUser);

    return 1;
}

sub _shallSkipForce {
    my ($self, $configuration) = @_;
    my $isRemovingHosts = IsRemovingLocalHost($configuration) || IsRemovingRemoteHost($configuration);
    my $isRemovingRoles = IsRemovingLocalRole($configuration) || IsRemovingRemoteRole($configuration);

    return ($isRemovingHosts || $isRemovingRoles) ? 0 : 1;
}

sub _shallSkipUserParameters {
    my ($self, $configuration) = @_;
    my $componentManager = $configuration->getSystemComponentManager();
    my $installedServerComponent = $componentManager->getComponentByKeyName($gKeynameEngine);
    return $installedServerComponent->isComponentSelected() ? 0 : 1;
}

1;