package LCM::Configuration::ValueChangeListeners::Update::AdditionalHostsListener;

use strict;
use LCM::Component;
use LCM::Configuration::ValueChangeListeners::CertificatesSkipValueConfigurator;

sub new { return bless({}, $_[0]); }

sub onValueChange {
	my ($self, $value, $instconfig) = @_;

	$instconfig->initRecommendationTexts();

	$instconfig->setAddHostsFilterRegex('.+');
	$instconfig->handleAdditionOfHosts($value);
	my $skippingCertificatesHelper = new LCM::Configuration::ValueChangeListeners::CertificatesSkipValueConfigurator();#Bug 100382
	$skippingCertificatesHelper->configureSkippingCertificates($instconfig);
# If hosts are added we need the sidadm password
	my $shallAdd = $self->_existAdditionalHosts($instconfig);
	$instconfig->setSkip('Password', 0) if($shallAdd);
	return 1;
}

sub _existAdditionalHosts {
	my ($self, $instconfig) = @_;
	my $addHostsString = $instconfig->getValue('AddHosts');
	return ( defined($addHostsString) && length($addHostsString) > 0 );
}

1;