package LCM::Configuration::ValueChangeListeners::Update::AdditionalRolesListener;

use strict;

sub new { return bless({}, $_[0]); }

sub onValueChange{
	my ( $self, $value, $instconfig ) = @_;
	$instconfig->handleSelectionOfHostRoles( $value );
# Calling 'private' sub might not be the brightest of ideas, but this is done in order to avoid duplicate calls to _recomputeRequiredRootCredentials
# GenerickStackUpdateConfiguration's sub handleAdditionOfHosts calls handleSelectionOfHostRoles too
	$instconfig->_recomputeRequiredRootCredentials();
	return 1;
}

sub onMapValueChange{
	my ( $self, $valKey, $value, $instconfig ) = @_;
	return $self->onValueChange($value, $instconfig);
}

1;