package LCM::Configuration::ValueChangeListeners::Update::RootPasswordListener;
use parent qw (LCM::Configuration::ValueChangeListeners::PostCollectHostInfoChecksListener);

use strict;
use SDB::Install::Configuration qw($bool_true_pattern);

sub new { return bless ({}, shift()); }

sub onValueChange {
    my ($self, $rootPassword, $instconfig) = @_;

    for my $remoteHosts (@{$instconfig->getRemoteHostsObjects()}){
        $remoteHosts->setUserPass( $rootPassword );
        my $returnCode = $remoteHosts->authPassword(0);

        return 0 if ( $returnCode );
    }

    if (! $self->checkCollectedHostInfo($instconfig)) {
        return 0;
    }

    require LCM::Configuration::ValueChangeListeners::FillingCertificatesListener;
    my $fillingCertificatesHelper = new LCM::Configuration::ValueChangeListeners::FillingCertificatesListener();
    $fillingCertificatesHelper->onValueChange( undef, $instconfig );

    require LCM::Configuration::ValueChangeListeners::CertificatesSkipValueConfigurator;
    my $skippingCertificatesHelper = new LCM::Configuration::ValueChangeListeners::CertificatesSkipValueConfigurator();
    $skippingCertificatesHelper->configureSkippingCertificates($instconfig);

    my $shallInstallSHA = ($instconfig->getValue('InstallHostagent') =~ /$bool_true_pattern/);
    if($shallInstallSHA){
        $instconfig->setSkip('HostagentPassword', $instconfig->_shouldSkipHostagentPassword());
    }
    $instconfig->fillInternalNetworkAndListenInterfaceValidValues();
    return 1;
}


1;
