package LCM::Configuration::ValueChangeListeners::Update::SIDHelper;

use strict;
use LCM::Configuration::NewDBUser::NewDBUser;
use base qw(LCM::Configuration::ValueChangeListeners::SIDHelperBase);

sub InitConfigUsername {
	my ($config, $sid) = @_;

	my $user = new LCM::Configuration::NewDBUser::NewDBUser($sid);


	if (! $user->exists ()) {
			$config->PushError("No such user '" . $user->getSidAdmName() . "'. User must exists, to proceed.");
			return 0;
	}

	return LCM::Configuration::ValueChangeListeners::SIDHelperBase::ConfigUsername($config, $user);
}

1;
