package LCM::Configuration::ValueChangeListeners::Update::ServerDetectionListener;

use strict;
use SDB::Install::Globals qw ($gKeynameEngine $gProductName $gUpgradeRestrictionsMessage GetServerNotFoundMessage GetNewerServerAlreadyInstalledMessage);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    my $mcm = $instconfig->getComponentManager();
    my $hanaServer = $mcm ? $mcm->getComponentByKeyName($gKeynameEngine) : undef;

    if(!defined($hanaServer)) {
        $instconfig->setErrorMessage(GetServerNotFoundMessage("$gProductName System update"));
        return 0;
    }

    if(!$self->_isServerUpdatable($instconfig, $hanaServer)) {
        return 0;
    }

# Artificially select the HDB server, so that the SignatureCheck listener will verify its signature
    $hanaServer->selectComponent(1);
    return 1;
}

sub _isServerUpdatable {
    my ($self, $instconfig, $detectedServer) = @_;
    my $scm = $instconfig->getSystemComponentManager();
    my $installedServer = $scm ? $scm->getComponentByKeyName($gKeynameEngine) : undef;
    if(!defined($installedServer)) {
        $instconfig->setErrorMessage("Failed to detect installed $gProductName Database server");
        return 0;
    }

    my $srcManifest = $installedServer->getManifest();
    my $trgManifest = $detectedServer->getManifest();
    my $srcVersion = $srcManifest->getVersionObject();
    my $trgVersion = $trgManifest->getVersionObject();

    if ($srcVersion->isNewerThan($trgVersion)) {
        if (!$instconfig->getIgnore('check_version')) {
            my $errorMessage = GetNewerServerAlreadyInstalledMessage($trgVersion->asString(), $srcVersion->asString());
            $instconfig->setErrorMessage($errorMessage);
            return 0;
        }
        $instconfig->getMsgLst()->addMessage("Ignoring version check errors due to command line switch '--ignore'");
    }

    if (!$trgManifest->checkSPSUpgradeLimitation($srcManifest)) {
        $instconfig->setErrorMessage($gUpgradeRestrictionsMessage, $trgManifest->getErrMsgLst());
        return 0;
    }

    return 1;
}

1;