package LCM::Configuration::ValueChangeListeners::Update::SystemDBSQLPasswordBatchHandler;

use strict;
use warnings;

sub new {
	my ($class) = @_;
	my $self = {};
	bless $self, $class;
	return $self;
}

sub onValueChange {
	my ($self, $value, $config) = @_;
	my $app = LCM::App::ApplicationContext::getInstance()->getApplication();
	if($config->isConvertToMultiDbRequired() && ($app->isBatchMode() && !$self->hasSystemDBSQLPasswordBatchValue($config))){
	    $config->getMsgLst()->addMessage($config->getParamName('SystemDBSQLPassword').' is not set : value of '.$config->getParamName('SQLSysPasswd'). ' will be used instead');
        $config->{_insideSystemDBSQLPasswordBatchHandler} = 1;
        $config->{params}->{'SystemDBSQLPassword'}->{batchValue} = $value;
        my $rc = $config->setBatchValue('SystemDBSQLPassword');
        $config->{_insideSystemDBSQLPasswordBatchHandler} = 0;
        return $rc;
	}
	return 1;
}

sub hasSystemDBSQLPasswordBatchValue{
    my($self,$config) = @_;
    if (defined $config->{options}->{read_password_from_stdin}){
        if($config->{options}->{read_password_from_stdin} eq 'xml'){
            return 1 if( defined $config->getPasswordFromXML(undef,$config->{params}->{'SystemDBSQLPassword'},1) );
        } else {
            if(!eof(STDIN)){
                return 1;
            }
       }
        
    } else {
        return 1 if ( defined $config->getBatchValue('SystemDBSQLPassword'));
    } 
    return 0 ;
}
1;