package LCM::Configuration::ValueChangeListeners::Update::UpdateExecutionModeListener;

use strict;

use SDB::Install::Globals qw ( $gOptionOptimizedUpdate $gOptionStandardUpdate );
use LCM::Component qw(PREPARE_PHASE OFFLINE_PHASE ONLINE_PHASE SYSTEM_ONLINE_PHASE ALL);

sub new {
	my ($class) = @_;

	my $self = {};
	bless $self, $class;

	return $self;
}

sub onValueChange {
	my ($self, $value, $config) = @_;

    if ($value eq $gOptionStandardUpdate && $config->isConvertToMultiDbRequired()) {
	    my $errorMsg = "Value \"$gOptionStandardUpdate\" is invalid. Conversion to multitenant database containers is only possible in $gOptionOptimizedUpdate update execution mode.";
        $config->setErrorMessage($errorMsg);
        return 0;
	}

	return 1;
}

1;
