package LCM::Configuration::ValueChangeListeners::Update::UpdateSystemBootstrapComponentListener;

use strict;
use parent 'LCM::Configuration::ValueChangeListeners::ComponentLocationListener';

sub new {
    my $self = shift->SUPER::new(@_);
    my ($scanner, $paramId) = @_;
    $self->setScanner($scanner);
    $self->setParamId($paramId);

    return $self;
}

sub setScanner {
    my ($self, $scanner) = @_;
    $self->{scanner} = $scanner;
}

sub getScanner {
    my ($self) = @_;
    return $self->{scanner};
}

sub setParamId {
    my ($self, $paramId) = @_;
    $self->{paramId} = $paramId;
}

sub getParamId {
    my ($self) = @_;
    return $self->{paramId};
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    return 0 if !$self->SUPER::onValueChange($value, $instconfig);

    my $scanner = $self->getScanner();
    my $paramId = $self->getParamId();
    my $parameter = $instconfig->{params}->{$paramId};

    if ($scanner->scan($paramId, $value)) {
        $instconfig->appendErrorMessage ("$parameter->{str} '$value' is invalid", $scanner->getErrMsgLst ());
        return undef;
    }

    return 1;
}

1;