package LCM::Configuration::ValueChangeListeners::Update::XS::XsTenantUserDetectionListener;

use strict;
use parent 'LCM::Configuration::ValueChangeListeners::Update::XS::BaseUpdateXSDetectionListener'; 

sub new {
    return bless({}, shift());
}
sub getConfigParamseter{}
sub getConfigParamseters{
	return ['TenantUser', 'SQLTenantUserPassword'];
}

sub getAdminLoginParameter{
    return 'runtime-database-name';
}

sub onValueChange {
	my ($self, undef, $instconfig) = @_;
	return 1 if ! $self->_isUpdatingXS2($instconfig);
	return $self->enableTenantCredentialsIfNecessary($instconfig);
}

sub enableTenantCredentialsIfNecessary {
	my ($self, $instconfig) = @_;
	my $isConvertRequired = $instconfig->isConvertToMultiDbRequired();
	my $adminLoginValue = $instconfig->retrieveXsAdminLoginParam($self->getAdminLoginParameter());
	my $shouldEnableTenantCredentials = ($adminLoginValue || $isConvertRequired);

	return 1 if !$shouldEnableTenantCredentials;

	foreach my $confParam (@{$self->getConfigParamseters()}){
		my $param = $instconfig->{params}->{$confParam};
		$param->{str} = sprintf($param->{str_templ}, $adminLoginValue);
		$instconfig->setSkip($confParam,0);
	}
	return 1;
}

1;
