package LCM::Configuration::Web::ExtractComponentsConfiguration;

use strict;
use LCM::Configuration::ParametersCreator;
use parent qw(LCM::Configuration::ExtractComponentsConfiguration);
use LCM::Configuration::ValueChangeListeners::ExtractComponents::UploadArchivesListener;
use LCM::Configuration::ValueChangeListeners::ExtractComponents::SelectedArchivesListener;
use LCM::Configuration::ValueChangeListeners::ExtractComponents::ComponentArchivesDirListener;

# Override
sub CheckParams {
    my $self = shift();
    my $result = $self->SUPER::CheckParams(@_);

    return $result;
}

# Override
sub InitDefaults {
    my $self = shift();

    return undef if(!$self->SUPER::InitDefaults(@_));

    for my $parameterId ('SapcarLocation', 'TarExecutableLocation', 'UnrarExecutableLocation'){
        next if(!exists($self->{params}->{$parameterId}));

        my $defaultPath = $self->getDefault($parameterId);
        if($self->setValue($parameterId, $defaultPath)){
            $self->setHidden($parameterId, 1);
        } else {
            $self->resetError();
        }
    }
    return 1;
}

# Override
# Important - changes done to this sub might alse affect LCM::Configuration::ExtractComponentsConfiguration::_addListeners
sub _addListeners {
    my ($self) = @_;
    $self->addParameterListener('UploadArchives', new LCM::Configuration::ValueChangeListeners::ExtractComponents::UploadArchivesListener());
    $self->addParameterListener('SelectedArchives', new LCM::Configuration::ValueChangeListeners::ExtractComponents::SelectedArchivesListener());
    $self->addParameterListener('ComponentArchivesPath', new LCM::Configuration::ValueChangeListeners::ExtractComponents::ComponentArchivesDirListener());
}

# Override
# Important - changes done to this sub might alse affect LCM::Configuration::ExtractComponentsConfiguration::_defineExtractComponentsParams
sub _defineExtractComponentsParams {
    my ($self) = @_;
    my $order = scalar keys %{$self->{params}};
    my $section = "ExtractComponents";

    $self->{params} = {
        'UploadArchives'          => $self->_getParamUploadArchives($order++, $section),
        'SelectedArchives'        => $self->_getParamSelectedArchives($order++, $section),
        'ComponentArchivesPath'   => GetParamComponentArchivesPath($order++, $section),
        'ExtractTempDir'          => GetParamExtractTempDir($order++, $section),
        'OverwriteExtractDir'     => GetParamOverwriteExtractDir($order++, $section),
        'SapcarLocation'          => GetParamSapcarLocation($order++, $section),
        'TarExecutableLocation'   => GetParamTarExecutableLocation($order++, $section),
        'UnrarExecutableLocation' => GetParamUnrarExecutableLocation($order++, $section),
    };
}

sub _getParamUploadArchives {
    my ($self, $order, $section) = @_;

    return {
        'order'             => $order,
        'opt'               => 'upload_archives',
        'opt_arg'           => '<true|false>',
        'type'              => 'boolean',
        'section'           => $section,
        'value'             => undef,
        'default'           => 0,
        'set_interactive'   => 1,
        'str'               => 'Upload Archives to the SAP HANA Host',
        'desc'              => 'Upload Archives to the SAP HANA Host',
        'mandatory'         => 0,
        'init_with_default' => 1,
    };
}

sub _getParamSelectedArchives {
    my ($self, $order, $section) = @_;

    return {
        'order'   => $order,
        'opt'     => 'selected_archives',
        'type'    => 'string',
        'section' => $section,
        'value'   => undef,
        'str'     => 'Selected Archives',
    };
}

1;