package LCM::Configuration::Web::GenericStackUninstallation;

use strict;
use LCM::Utils::ComponentActionStringGenerator::WebUninstall;
use LCM::Configuration::ValueChangeListeners::Uninstall::Web::SelectedComponentsListener;
use LCM::Configuration::ValueChangeListeners::Uninstall::RecomputeCredentialsListener;
use LCM::Configuration::ValueChangeListeners::Uninstall::Web::ForceListener;
use LCM::Configuration::ParametersCreator qw(GetParamExistingHosts GetParamIgnore);
use LCM::Configuration::GenericStackAny qw($ini_section_general);
use parent 'LCM::Configuration::GenericStackUninstallation';

sub new {
    my $self = shift()->SUPER::new (@_);

    $self->_addSlpSpecificParameters();

    $self->setSkip('KeepUser', 0); # Make this parameter visible in the Advanced Configuration
    $self->setSkip('KeepUserHomeDir', 0); # Make this parameter visible in the Advanced Configuration
    $self->setHidden('RemoveHosts', 0); # Make this parameter visible for the summary
    $self->setHidden('RemoveRoles', 0); # Make this parameter visible for the summary

    return $self;
}

sub InitDefaults {
    my $self = shift();
    my $result = $self->SUPER::InitDefaults(@_);

    if($result){
        $self->_convertParameterRemoveHostsToCsv();
        $self->_initParamExistingHosts();
    }
    return $result;
}

# Override
sub addListeners {
    my ($self) = @_;
    $self->addParameterListener('SelectedComponents', new LCM::Configuration::ValueChangeListeners::Uninstall::Web::SelectedComponentsListener());
    $self->addParameterListener('SelectedComponents', new LCM::Configuration::ValueChangeListeners::Uninstall::RecomputeCredentialsListener());
    $self->addParameterListener('ForceRemoveHosts', new LCM::Configuration::ValueChangeListeners::Uninstall::Web::ForceListener());
    $self->addParameterListener('ForceRemoveHosts', new LCM::Configuration::ValueChangeListeners::Uninstall::RecomputeCredentialsListener());
    $self->addParameterListener('RemoveRoles',$self->getAutoInitFamilyServicesParameterHanlder('RemoveRoles'));
    $self->addParameterListener('RemoveHosts',$self->getAutoInitFamilyServicesParameterHanlder('RemoveHosts'));
}

sub setIgnore {
    my ($self, $value) = @_;
    my $optionIgnore = $self->getOptionIgnore();

    return 0 if(! defined($optionIgnore));
    if(! $optionIgnore->parseArgs($value)){
        $self->appendErrorMessage(undef,$optionIgnore->getErrMsgLst ());
        return 0;
    }

    $self->{params}->{Ignore}->{value} = $value;
    return 1;
}

sub getComponentKeynameToAction {
    my ($self) = @_;
    my $generator = new LCM::Utils::ComponentActionStringGenerator::WebUninstall();

    return $generator->getComponentKeynameToActionMap($self, undef, $self->getSystemComponentManager());
}

sub _addSlpSpecificParameters {
    my ($self) = @_;
    my $ignoreValues = $self->getIgnoreValues();
    my $order = scalar(keys(%{$self->{params}})) + 1;

    $self->{params}->{ExistingHosts} = GetParamExistingHosts($order++, $ini_section_general);
    if(defined($ignoreValues) && scalar(@{$ignoreValues})){
        $self->{params}->{Ignore} = GetParamIgnore($order++, $ini_section_general, $ignoreValues);
    }
}

sub _initParamExistingHosts {
    my ($self) = @_;
    my $existingHostsParameter = $self->{params}->{ExistingHosts};
    my $instance = $self->getOwnInstance(1);
    my $hostRolesInfo = $instance->getHostRolesInfo();
    my @existingHostsWithRoles = map { "${_}:role=" . join(':role=', split('\s+', $hostRolesInfo->{$_})) } @{$self->getSystemHosts()};

    $existingHostsParameter->{value} = join(',', @existingHostsWithRoles);
}

# Parameter RemoveHosts is converted to CSV, because this would generically expose it via the
# SLP, showing all valid hosts for removal
sub _convertParameterRemoveHostsToCsv {
    my ($self) = @_;
    my $instance = $self->getOwnInstance();
    my $hostRolesInfo = $instance->getHostRolesInfo();
    my $removeHostsParameter = $self->{params}->{RemoveHosts};

    $self->setType('RemoveHosts', 'csv');
    $removeHostsParameter->{valid_values} = $instance->get_hosts();
    $removeHostsParameter->{ui_values} = [map { "Roles: " . join(',', split('\s+', $hostRolesInfo->{$_})) } @{$instance->get_hosts()}];
}

1;