package LCM::DevelopmentTrace;

use strict;
use File::Spec;

my $devTraceFile;
my $devTraceFileHandle;
my $isDevTraceEnabled;

sub EnableDevelopmentTrace {
	my ($logDir, $filename) = @_;
	if ($isDevTraceEnabled) {
		return 1;
	}
	if (!(-d $logDir)) {
		return 0;
	}
	$devTraceFile = File::Spec->catfile($logDir, $filename);
	if(open($devTraceFileHandle, '>', $devTraceFile)){
		$isDevTraceEnabled = 1;
		# switch auto flush on
		my $old = select ($devTraceFileHandle);
		$| = 1;
		select ($old);
	}
	return 1;
}

sub isEnabledDevelopmentTrace { return $isDevTraceEnabled; }

sub GetDevelopmentTraceFile { return $devTraceFile; }

sub Trace {
	my ($text) = @_;
	return unless ($isDevTraceEnabled && $devTraceFileHandle);
	print $devTraceFileHandle $text;
}

sub DisableDevelopmentTrace {
	return unless($devTraceFileHandle && $isDevTraceEnabled);
	if(close($devTraceFileHandle)){
		$isDevTraceEnabled = 0;
	}
}

sub RemoveTempDevelopmentTrace {
	if (!$ENV{HDB_INSTALLER_TRACE_FILE}){
		RemoveDevelopmentTrace();
	}
}

sub RemoveDevelopmentTrace {
	$isDevTraceEnabled = 0;
	if (defined $devTraceFile && -f $devTraceFile) {
		unlink $devTraceFile;
	}
	undef $devTraceFile;
}

1;
