package LCM::Executors::ExecutionWarningsHandler;
use strict;

sub new {
	my ( $class, $executor ) = @_;
	my $self = {};
	bless $self, $class;
	$self->{executor} = $executor;
	return $self;
}

sub onWarning {
	my ( $self, $message ) = @_;

	if ((!defined $message) || ($message eq '')) {
		return 1;
	}

	$self->_addMessage($message);
	if($self->{executor}->can('_addWarningMessage')) {
	   $self->{executor}->_addWarningMessage($message);
	} else {
	   $self->{executor}->setWarnings( $self->{_messages} );
	}

	return 1;
}

sub _addMessage {
	my ( $self, $message ) = @_;
	$message =~ s/^\s+|\s+$//g;    #trim
	if ( !defined $self->{_messages}) {
		$self->{_messages} = [];
	}
	push( @{$self->{_messages}}, $message );
	$self->_removeDuplicateMessages();
	  
}
sub _removeDuplicateMessages(){
	my ( $self ) = @_;
	my %messageMap = map {$_ => 1} @{$self->{_messages}};
    my @nonDuplicateMessages = keys %messageMap;
    @{$self->{_messages}} = @nonDuplicateMessages;
}

1;
