#!/usr/bin/perl

package LCM::Gui::App::LCMGuiApp;

use strict;
use SDB::Install::App::Gui;
use SDB::Install::DebugUtilities;
use LCM::Gui::Frame::HdbLcmGuiFrame;
use LCM::Configuration::HdbLcmInstalledActionConfiguration;
use LCM::Configuration::HdbLcmExternalActionConfiguration;
use LCM::App::ApplicationContext;
use LCM::Executors::ExecutionExitCodeHandler;
use LCM::ExecutionWarningsObservable;
use LCM::PersistencyUtils qw (getAllPendingUpdateInfo);
use SDB::Install::System qw (isSidadmin);
use LCM::Fcgi::App::EnvironmentUtilities;
use LCM::App::CLIArgumentsParser;

use base qw (LCM::App::AbstractApplication SDB::Install::App::Gui);

sub new {
	my $self = shift->SUPER::new();

	$self->{hdblcm} = 1;
	$self->registerExitCodeHandler();
	$self->registerAbortSignalHandler();
	LCM::App::ApplicationContext::getInstance()->setApplication($self);

	return $self;
}

sub InitApp {

	my ($self) = @_;

	$self->setCommonLogDir('HDBLCM_LOGDIR', 'hdblcm.log');
	$self->setCLIParser(LCM::App::CLIArgumentsParser->new($self));
	$self->SUPER::InitApp();
	return 1;
}

sub main {
    my $app =  _createApp();

	my $actionConfig = $app->createActionConfiguration();

	$app->setActionConfiguration($actionConfig);

    $app->{stackBacktraceMsglst} = new SDB::Install::MsgLst ();

    my $rc = undef;;
	if (!$app->errorState()) {
		eval{
			$rc = $app->InitCmdLineArgs (\@_);

			if (!defined $rc){
				return undef;
			}

			if (defined $app->{return}){
				LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
				return $app->{return};
			}

			$app->startMainLoop ();
		};
	}

	if (!defined $app->{return}) {
		$rc = $app->handleReturnCodes( $@, $rc );
		$app->CleanUp();
	}

	if (defined $app->{_exitCodeHandler} && defined $app->{_exitCodeHandler}->getExitCodeOnWarning()) {
		return $app->{_exitCodeHandler}->getExitCodeOnWarning();
	}

	return $app->{return} if ( defined $app->{return} );

	undef $app;

	return (defined $rc) ? 0 : 1;
}

sub _createApp {
    my $installer = new LCM::Installer ();
	if ($installer->isInstalled()) {
		require LCM::Gui::App::LCMGuiAppInstalled;

# Explicitly prepare execution environment for sidadm execution cases
		my $sid = $installer->getSid();
		PrepareExecutionEnvironment($sid) if(isSidadmin($sid));

		return new LCM::Gui::App::LCMGuiAppInstalled ();
	} else {
		require LCM::Gui::App::LCMGuiAppExternall;
		return new LCM::Gui::App::LCMGuiAppExternall();
	}
}

sub isGUIApplication {
	return 1;
}

sub InitCmdLineArgs {
    my ($self,$args) = @_;
    my $rc = $self->SDB::Install::App::AnyApp::InitCmdLineArgs($args,1);
    
    if (!$rc) {
        return undef;
    }
    
    my $instconfig = $self->createActionConfiguration ();
    $self->setActionConfiguration($instconfig);
		
 	$instconfig->setMsgLstContext([$self->getMsgLst()]);
    $instconfig->InitDefaults ();

    $self->getCLIParser()->parse(1);
    $instconfig->CheckParams (0);

    $instconfig->setBatchValueOfRequiredParams('Action');
    my $action = $instconfig->getParamValue('Action');
    if($action) {
        $instconfig = $self->createConfiguration($action);
        if (!$instconfig->InitDefaults()) {
            my $errorList = $instconfig->getErrMsgLst();
            my $errorMessage = $errorList->isEmpty() ? '' : ${$errorList->getMsgLstString()};
            $self->setErrorMessage($errorMessage);
            return undef;
        }
        $self->setInstconfig($instconfig);
    }
    if ($self->isHelp()) {
        $self->createExecutor($action)->execute();
        $self->{return} = 0;
        return 1;
    }
    return $rc;
}

sub getFrameWindow {
	my ($self) = @_;
	return new LCM::Gui::Frame::HdbLcmGuiFrame($self, [ -1, -1 ], [ 800, 650 ] );
}

sub getActionConfiguration{
	return $_[0]->{actionInstconfig};
}

sub setActionConfiguration {
	$_[0]->{actionInstconfig} = $_[1];
	$_[0]->{instconfig} = $_[1];
}

sub setInstconfig {
	my ($self, $instconfig) = @_; 
	if(!defined $instconfig){
		return;
	}
   	my $context = [$self->getMsgLst(), $self->getErrMsgLst()];
	$context->[0]->addMessage(undef, $instconfig->getMsgLst());
   	$context->[1]->addMessage(undef, $instconfig->getErrMsgLst());
   	$instconfig->setMsgLstContext($context);

	$self->SUPER::setInstconfig($instconfig);
}

sub getProgramName{
	return 'hdblcmgui';
}

sub getPendingUpdateInfo {
	my ($self, $sapSys) = @_;
	return getAllPendingUpdateInfo($sapSys, "\t", '');
}

sub setGUIWizard {
	my ($self, $wizard) = @_;
	$self->{wizard} = $wizard;
}

sub getGUIWizard {
	my ($self) = @_;
	return $self->{wizard};
}

1;
